
markup.push(
{
	BuiltinScripts:
	{
		scriptsList: [
						  
			// MARK: script: Discard Small Files
			{
				nsClass: "AH4Script",
				scriptUUID:	"builtin_script_discard_small_files_000",
				scriptName: "Discard Small Files",
				scriptText:
// --------------------------------------------------------
`// if a file is less than 5 seconds long,
// throw it in the trash when it ends
// #needsFile

let file = event.file;
if (file == null)
	return;

if (file.fileTime > 5)
	return;

console.dialog("Throwing the short file \'" + file.fileName + "\' away");

file.sendToTrash();
`
// --------------------------------------------------------
			},
			// MARK: script: Add Recording to Music
			{
				nsClass: "AH4Script",
				scriptUUID:	"builtin_script_add_to_music_000",
				scriptName: "Add Recording to Music",
				scriptText:
// --------------------------------------------------------
`// add the current file to Music.app
// #needsFile

if (event.file != null)
	event.file.addToMusic();
`
// --------------------------------------------------------
			},
//			// MARK: script: Disable Recorder Blocks
//			{
//				nsClass: "AH4Script",
//				scriptUUID:	"builtin_script_disable_recorders_000",
//				scriptName: "Disable Recorder Blocks",
//				scriptText:
//// --------------------------------------------------------
//`// disable all the Recorder blocks in a session
//// #needsSession
//
//if (event.session == null)
//	return;
//
//event.session.blocks.forEach( block =>
//{
//	if (block.name == "Recorder")
//		block.disabled = true;
//});
//`
//// --------------------------------------------------------
//			},
//			// MARK: script: Mute Output Devices
//			{
//				nsClass: "AH4Script",
//				scriptUUID:	"builtin_script_mute_outputs_000",
//				scriptName: "Mute Output Devices",
//				scriptText:
//// --------------------------------------------------------
//`// mute the output devices in a session
//// #needsSession
//
//if (event.session == null)
//	return;
//
//event.session.blocks.forEach(block =>
//{
//	if (block.name == "Output Device")
//		block.disabled = true;
//});
//`
//// --------------------------------------------------------
//			},
			// MARK: script: Quit Audio Hijack
			{
				nsClass: "AH4Script",
				scriptUUID:	"builtin_script_quit_000",
				scriptName: "Quit Audio Hijack",
				scriptText:
// --------------------------------------------------------
`// stop all sessions first, which avoids
// warning dialogs if sessions are running

app.stopAllSessions();

app.quit();
`
// --------------------------------------------------------
			},
			// MARK: script: Reveal in Finder
			{
				nsClass: "AH4Script",
				scriptUUID:	"builtin_script_reveal_in_finder_000",
				scriptName: "Reveal Recording in Finder",
				scriptText:
// --------------------------------------------------------
`// Show a file in the finder
// #needsFile

let file = event.file;
if (file == null)
	return;

console.log("Revealing " + file.fileName + " in the Finder");

file.revealInFinder();

`
// --------------------------------------------------------
			},
			// MARK: script: Open in Editor
			{
				nsClass: "AH4Script",
				scriptUUID:	"builtin_script_open_in_editor_000",
				scriptName: "Open Recording in Editor",
				scriptText:
// --------------------------------------------------------
`// Open a file in the editor
// #needsFile

let file = event.file;
if (file == null)
	return;

console.log("Opening " + file.fileName + " in the Editor");

file.openInEditor();

`
// --------------------------------------------------------
			},
			// MARK: script: Show Session Window
			{
				nsClass: "AH4Script",
				scriptUUID:	"builtin_script_open_session_window_000",
				scriptName: "Open Session Window",
				scriptText:
// --------------------------------------------------------
`// open the Session's window and bring Audio Hijack to the front
// #needsSession

if (event.session == null)
	return;

event.session.showWindow();

app.bringToFront();

`
// --------------------------------------------------------
			},


 
	],	// end of list
},
	
})
